% Cognition and Natural Sensory Processing (CNSP) Workshop
% Lalor Natural Speech Preprocessing
%
% CNSP-Workshop 2021
% https://cnsp-workshop.github.io/website/index.html
% Author: Giovanni M. Di Liberto, Aaron Nidiffer
% Copyright 2020-2021 - Giovanni Di Liberto
%                       Nathaniel Zuk
%                       Michael Crosse
%                       Aaron Nidiffer
%                       (see license file for details)
% Last update: 1 August 2021

clear; clc;
close all

% Uncomment if you need these toolboxes
addpath libs/cnsp_utils
addpath libs/cnsp_utils/cnd
% addpath libs/mTRF-Toolbox_v2/mtrf
% addpath libs/NoiseTools
% addpath libs/eeglab
% eeglab


%% Parameters - Natural speech listening experiment
folderRoot = pwd;
folderCND = [folderRoot '\dataCND\'];

reRefType = 'Avg'; % or 'Mastoids'
bandpassFilterRange = [1,8]; % Hz (indicate 0 to avoid running the low-pass
                          % or high-pass filters or both)
                          % e.g., [0,8] will apply only a low-pass filter
                          % at 8 Hz

%% Preprocess EEG - Natural speech listening experiment
eegFilenames = dir([folderCND 'dataSub*.mat']);
nSubs = length(eegFilenames);

for sub = 1:nSubs
    % Loading EEG data
    eegFilename = [folderCND eegFilenames(sub).name];
    disp(['Loading EEG data: ' eegFilenames(sub).name])
    load(eegFilename,'eeg')
    cndNewOp(eeg,'Load') % Saving the processing pipeline in the eeg struct

    % Filtering - LPF (low-pass filter)
    if bandpassFilterRange(2) > 0
        hd = getLPFilt(eeg.fs,bandpassFilterRange(2));
        
        % Filtering each trial/run with a for loop
%         for ii = 1:length(eeg.data)
%             eeg.data{ii} = filtfilthd(hd,eeg.data{ii});
%         end
        
        % Filtering each trial/run with a cellfun statement
        eeg.data = cellfun(@(x) filtfilthd(hd,x),eeg.data,'UniformOutput',false);
        
        % Filtering external channels
        if isfield(eeg,'extChan')
            for extIdx = 1:length(eeg.extChan)
                eeg.extChan{extIdx}.data = cellfun(@(x) filtfilthd(hd,x),eeg.extChan{extIdx}.data,'UniformOutput',false);
            end
        end
        
        cndNewOp(eeg,'LPF');
    end
    
    % Filtering - HPF (high-pass filter)
    if bandpassFilterRange(1) > 0 
        hd = getHPFilt(eeg.fs,bandpassFilterRange(1));
        
        % Filtering EEG data
        eeg.data = cellfun(@(x) filtfilthd(hd,x),eeg.data,'UniformOutput',false);
        
        % Filtering external channels
        if isfield(eeg,'extChan')
            for extIdx = 1:length(eeg.extChan)
                eeg.extChan{extIdx}.data = cellfun(@(x) filtfilthd(hd,x),eeg.extChan{extIdx}.data,'UniformOutput',false);
            end  
        end
        
        cndNewOp(eeg,'HPF');
    end
    
    % Replacing bad channels
    if isfield(eeg,'chanlocs')
        for tr = 1:length(eeg.data)
            eeg.data{tr} = removeBadChannels(eeg.data{tr}, eeg.chanlocs);
        end
    end
    
    % Re-referencing EEG data
    eeg = cndReref(eeg,reRefType);
    
    % Saving preprocessed data
    eegPreFilename = [folderCND 'pre_' eegFilenames(sub).name];
    disp(['Saving preprocessed EEG data: pre_' eegFilenames(sub).name])
    save(eegPreFilename,'eeg')
end


