% Contains partial solution for banded ridge tutorial. Spoiler be ahead.

if 0 % Don't execute this block
    
    % Hard-coded solution
    for tr = 1:size(stim.data,2)
        stim.data{5,tr} = [stim.data{1,tr} stim.data{2,tr}];
        stim.names{5} = [stim.names{1} stim.names{2}];
        
        stim.data{6,tr} = [stim.data{3,tr} stim.data{4,tr}];
        stim.names{6} = [stim.names{3} stim.names{4}];
        
        stim.data{7,tr} = [stim.data{3,tr} stim.data{4,tr} stim.data{2,tr}];
        stim.names{7} = [stim.names{3} stim.names{4} stim.names{2}];
    end
    
elseif 0 % Don't execute this block
    
    % Cellfun version of the code in the else block should be possible but
    % I couldn't get there
    dim = cell(size(stim.data(1,:))); dim(:) = deal({2});
    test = cellfun(@cat,dim,stim.data([1 2],:));
    
else
    
    %More adaptable, modular solution that can construct arbitrary number
    %of pre-defined models
    nFeatures = size(stim.data,1);
    dimE = 1; stim.names{dimE} = 'E'; % Also shorten the model names.
    dimO = 2; stim.names{dimO} = 'O';
    dimS = 3; stim.names{dimS} = 'S';
    dimF = 4; stim.names{dimF} = 'F';
    
    % Construct list of new models.
    newModels = {[dimE dimO], ...
        [dimS dimF], ...
        [dimS dimF dimO]};
    
    % Now loop through everything and concatenate the appropriate features.
    for mm = 1:length(newModels)
        for tr = 1:size(stim.data,2)
            stim.data{nFeatures+mm,tr} = cat(2,stim.data{newModels{mm},tr});
            
        end
        stim.names{nFeatures+mm} = strcat(stim.names{newModels{mm}});
    end
end