function y=rms(x, dim)
%RMS - Root-mean-square
% 
%  y=rms(x): If x is a matrix the rms is calculated columnwise.
%  y=rms(x,dim): calculate rms according to dim.
% 
%  see also nt_bsrms, nt_bsplot
%
% NoiseTools
 
% if row vector transpose to column
if size(x,1) == 1 ; x = x'; end
 
if nargin == 2
    if dim == 0; 
        y=sqrt(sum(sum(x.^2))/prod(size(x)));
    else
        y=sqrt(sum(x.^2,dim)/size(x,dim));
    end
else
    y=sqrt(sum(x.^2)/size(x,1));
end
