function Hd = getHPFilt(Fs,Fc,N)
%GETHIGHPASSFILT Returns a discrete-time filter object.
%
% MATLAB Code
% Generated by MATLAB(R) 9.5 and Signal Processing Toolbox 8.1.
% Generated on: 11-Nov-2019 18:00:27
%
% Butterworth Highpass filter designed using FDESIGN.HIGHPASS.
%
% All frequency values are in Hz.
%
% Input:
%  Fs: sampling frequency
%  Fc: cut-off frequency
%  N: filter order
%
% Output:
%  Hd: filter structure
%
% Example:
%  Hd = getHPFilt(Fs,Fc,N);
%  xFilt = filtfilthd(Hd,x);
%
% Modified by: Giovanni Di Liberto
% Last update: 9 July 2021
%

if ~exist('N','var') || isempty(N)
    N = 4;
end

% Construct an FDESIGN object and call its BUTTER method.
h  = fdesign.highpass('N,F3dB', N, Fc, Fs);
Hd = design(h, 'butter');

% [EOF]
