function Hd = getLPFilt(Fs,Fc,N)
%GETLOWPASSFILT Returns a discrete-time filter object.
%
% MATLAB Code
% Generated by MATLAB(R) 9.5 and Signal Processing Toolbox 8.1.
% Generated on: 03-Mar-2020 22:47:23
%
% Butterworth Lowpass filter designed using FDESIGN.LOWPASS.
%
% Input:
%  Fs: sampling frequency
%  Fc: cut-off frequency
%  N: filter order
%
% Output:
%  Hd: filter structure
%
% Example:
%  Hd = getLPFilt(Fs,Fc,N);
%  xFilt = filtfilthd(Hd,x);
%
% Modified by: Giovanni Di Liberto
% Last update: 9 July 2021
%

if ~exist('N','var') || isempty(N)
    N = 4;
end

% Construct an FDESIGN object and call its BUTTER method.
h  = fdesign.lowpass('N,F3dB', N, Fc, Fs);
Hd = design(h, 'butter');

% [EOF]
