function S = randherm(n, N)
% Generates random Hermitian matrices with normal entries.
% 
% function S = randherm(n)
% function S = randherm(n, N)
%
% S is an n-by-n-by-N array where each slice S(:, :, i) for i = 1..N is a
% random Hermitian matrix formed by
%
%   S = (randsym(n, N) + 1i*randskew(n, N))/sqrt(2);
%
% By default, N = 1.
%
% See also: randskew randunitary randrot randsym randskewh

% This file is part of Manopt: www.manopt.org.
% Original author: Nicolas Boumal, June 18, 2019.
% Contributors: 
% Change log: 

    if nargin < 2
        N = 1;
    end

    S = (randsym(n, N) + 1i*randskew(n, N))/sqrt(2);

end
